#ifndef GST_ShapeOutputConfig_hpp__
#define GST_ShapeOutputConfig_hpp__

#include <boost/optional.hpp>

#include <string>

#include "exceptions/GSTRuntimeException.h"

#include "buildspec.h"

namespace GST
{
namespace exceptions
{
/**
 * Thrown when an error in the intersection config json exists.
 * This could be due to wrong syntax or missing arguments
 */
class ShapeOutputConfigError : public GSTRuntimeException
{
public:
	ShapeOutputConfigError(const std::string &throwLocation,
						   const std::string &msg)
		: GSTRuntimeException(throwLocation, msg)
	{
	}
};
} // namespace exceptions
namespace ShapeOutputConfig
{
struct BavariaConfig
{
	boost::optional<std::string> profileLineFileName;
	boost::optional<std::string> bendPointFileName;
	boost::optional<std::string> verticalLinesFileName;
	boost::optional<std::string> horizontalLineFileName;
};
struct Config
{
	boost::optional<double> verticalExaggeration;
	boost::optional<bool> worldCoordinates;
	boost::optional<double> distanceBetweenBoreholes;
	boost::optional<double> boreholePolygonWidth;
	boost::optional<std::string> title;
	boost::optional<std::string> titleColumnName;
	boost::optional<std::string> exaggerationColumnName;
	boost::optional<std::string> origNameColumnName;
	boost::optional<std::string> aliasNameColumnName;
	boost::optional<std::string> dateColumnName;
	boost::optional<std::string> modelColumnName;
	boost::optional<std::string> pointsFileName;
	boost::optional<std::string> linesFileName;
	boost::optional<std::string> polygonsFileName;
	// boreholes
	boost::optional<std::string> boreholesFileName;
	boost::optional<std::string> boreholesIdColumnName;
	boost::optional<std::string> boreholesNameColumnName;
	boost::optional<std::string> boreholesShortNameColumnName;
	boost::optional<std::string> boreholesEastingColumnName;
	boost::optional<std::string> boreholesNorthingColumnName;
	boost::optional<std::string> boreholesElevationColumnName;
	boost::optional<std::string> boreholesTotalLengthColumnName;
	boost::optional<std::string> boreholesProjDistColumnName;
	// borehole layers
	boost::optional<std::string> layersFileName;
	boost::optional<std::string> layersPolygonFileName;
	boost::optional<std::string> layersBoreholeIdColumnName;
	boost::optional<std::string> layersBoreholeNameColumnName;
	boost::optional<std::string> layersBoreholeShortNameColumnName;
	boost::optional<std::string> layersBoreholeProjDistColumnName;
	boost::optional<std::string> layersIdColumnName;
	boost::optional<std::string> layersElevationFromColumnName;
	boost::optional<std::string> layersElevationToColumnName;
	boost::optional<std::string> layersDepthFromColumnName;
	boost::optional<std::string> layersDepthToColumnName;
	boost::optional<std::string> layersStratNameColumnName;
	boost::optional<std::string> layersStratShortNameColumnName;
	boost::optional<std::string> layersStratColorColumnName;
	boost::optional<std::string> layersPetroNameColumnName;
	boost::optional<std::string> layersPetroShortNameColumnName;
	boost::optional<std::string> layersPetroColorColumnName;
	// dem
	boost::optional<std::string> demFileName;
	// Bavaria special options
	boost::optional<BavariaConfig> bavariaConfig;
};

GST_API_EXPORT void fromJson(Config &config, const std::string &json);
GST_API_EXPORT void toJson(std::string &json, const Config &config);
} // namespace ShapeOutputConfig
} // namespace GST

#endif // GST_ShapeOutputConfig_hpp__
